
libname mafe "..................";


**********************
** ANALYSIS DATASET **
**********************


/* person year database for each year of life */
data year; set mafe.general;
a2008=2008;
dur=a2008-q1a+1;
run; 

%macro expand(table,duree);
data &table; 
set &table; 
do j=1 to &duree; 
if j=&duree then do; 
end; 
output; 
end; 
run;
%mend expand;

%expand(year, dur);

data year; set year;
year=q1a+j-1;
age= j-1;
run;

data year(drop=  q1a j dur a2008); set year;
        label year= "year";
        label age= "age";
run;

/* Countries  for respondant*/
data migration; 
 set mafe.migration;
if q601f=2008 then end_08=1;
if q601f=2008 then q601f=2007;
if q601f=. then q601f=2008;
run;

data migration; set migration;
dur=q601f-q601d+1;
if dur=. then delete;
run;

%expand(migration, dur);

proc sort; by ident num_mig; run;
data migration; 
 set migration;
year=q601d+j-1;
by ident num_mig;
run;

data migration(drop=j dur end_08); set migration;
if (q601f=year & year ne 2008 & end_08 ne 1 ) then delete;
run;

proc sort out= migration; 
by ident year; run;


proc sort data=year;
by ident year; run;

data loc_resp (rename=(q602= loc_resp) drop=end_08);
merge year migration;
by ident year;
run;

data loc_resp (keep = ident year age loc_resp); 
 set loc_resp; 
if loc_resp=. then loc_resp=99341;
run;


/* Countries for partner(s) */
data net_conj; set mafe.network; 
if q901=1;
if q904f=2008 then end_08=1;
if q904f=2008 then q904f=2007;
if q904f=. then q904f=2008;
run;


data net_conj; set net_conj; 
dur=q904f-q904d+1;
if dur=. then delete;
run;

%expand(net_conj, dur);

proc sort; 
by ident id_uni num_netmig; run;

data net_conj;  set net_conj;
year=q904d+j-1;
by ident id_uni num_netmig;
run; 

data  net_conj(keep= ident id_uni country q904d q904f year);
 set  net_conj;
if (q904f=year & year ne 2008 & end_08 ne 1) then delete;
run;

proc sort; by id_uni year; run;


/* separation dataset */
data separation (keep= ident num_union q102d q102f q103 id_uni); set mafe.union;
if q103=. then delete;
run;
data separation; set separation;
dur=2008-q102f+1;
run;
%expand(separation, dur);
data separation;  set separation;
year=q102f+j-1;
by id_uni;
run; 
data separation (keep=ident num_union id_uni q103 year);  set separation;
run;
proc sort; by id_uni year; run;


/* union dataset */
data union(drop=q103); set mafe.union;
if q102f=2008 then end_08=1;
if q102f=2008 then q102f=2007;
if q102f=. then q102f=2008;
run;

data union;
  set union; 
dur=q102f-q102d+1;
if dur=. then delete;
run;

%expand(union, dur); 

data union; set union;
year=q102d+j-1;
run;

data  union(keep =ident num_union id_uni q102d q102f  q105 q107 year); 
 set union;

if (q102f=year & year ne 2008 & end_08 ne 1) then delete;
run;

proc sort; by id_uni year;
run; 

/* merge union net_conj separation */
data loc_conj(drop=q904d q904f q102d q102f);  merge net_conj union separation ; by id_uni year;
if num_union=. then delete;
if country=. & q103=. then country=q107;
if q103 ne . then country=.;
run;

data loc_conj; set loc_conj;
rename country=loc_conj;
label loc_conj="loc_conj";
run;

proc sort; by ident; run;

/**** fix overlapping******/
data loc_conj(drop= y); set loc_conj;
y=put(year, $4.);
id=ident || y;
run ;

/* variable num_uni*/
data loc_conj; set loc_conj;
if q103=. then num_uni=num_union;
run;
proc sort data= loc_conj; by id;run;

/* variable nbu*/
proc summary data=loc_conj;
class id; var num_uni;
where num_uni ne .;
output out= nbu(drop= _type_ _freq_) N= nbu;
run;
data nbu; set nbu;
if id="" then delete;
proc sort data= nbu; by id; run;

%macro reshape(var,i);
proc transpose data=loc_conj
out= b&i prefix=&var; 
by id; id num_union;
var &var; run;
data b&i (drop=_NAME_ _LABEL_); set b&i; run;
%mend reshape; 

%reshape(q103,1);
%reshape(q105,2);
%reshape(loc_conj,3);
%reshape(num_uni,4);

data c2; merge b1 b2; by id; run;
data c3; merge c2 b3; by id; run;
data c4; merge c3 b4; by id; run;
data loc_conj1; merge c4 nbu; by id; run;
proc sort data= loc_conj1; by id; run;

proc datasets;
delete c2-c4 b1-b4;
run;


/* merge loc_resp loc_conj1*/
data loc_resp (drop= y); set loc_resp;
y=put(year, $4.);
id=ident || y;
run ;
proc sort; by id; run; 

data analys; merge loc_resp loc_conj1 nbu; by id;
if age<14 then delete;
if nbu=. then nbu=0;
run;


proc datasets;
delete loc_conj loc_conj1 loc_resp1  migration nbu net_conj separation union year ;
run;

data analys(drop=id);
retain ident year age loc_resp 
       num_uni1 q1031 q1051 loc_conj1  
       num_uni2 q1032 q1052 loc_conj2  
       num_uni3 q1033 q1053 loc_conj3  
       num_uni4 q1034 q1054 loc_conj4  
       num_uni5 q1035 q1055 loc_conj5 
       nbu;
set analys;
run;

/* ANALYSIS VARIABLES */


/* q105 */
data analys(drop=i); set analys;
array q105{5} q1051 - q1055;
array num_uni{5} num_uni1-num_uni5;
do i=1 to 5;
         if q105{i}>year & num_uni{i} ne . then q105{i}=.;
end;
run;
																

/** Dummy for being alone and never in partnership**/
data analys; set analys;
if num_uni1=. & q1031=. then C=1;
if C=. then C=0;
label C= " Alone, never in partnership =1" ;
run;

/*  Dummy for widowing */
data analys(drop= i V_:); set analys;
array q103[5] q1031-q1035;
array V_[5] V_1-V_5;
i=0;
do i=1 to  5;
             if q103[i]=2 then V_[i]=1;
end;
v_s = sum(of V_[*]);
if v_s>0 then V=1;
if V=. then V=0;
label V= " Widowed =1" ; 
run;

/**  Dummy for separation **/
data analys(drop= i D_:);  set analys;
array q103[5] q1031-q1035;
array D_[5] D_1-D_5;
do i=1 to 5;
            if q103[i]=1 then D_[i]=1; 
end;
d_s = sum(of D_[*]);
if d_s>0  then D=1;
if D=. then D=0;
label D= " Divorced or separated =1" ;
run;

/** Dummy for free union **/
data analys(drop= i U_:); set analys;
array q105[5] q1051-q1055;
array num_uni[5] num_uni1-num_uni5;
array U_[5] U_1-U_5;
do i=1 to 5;
             if num_uni[i] ne . & q105[i]=. then U_[i]=1; 
end;
u_s = sum(of U_[*]);
if u_s>0 then U=1;
if U=. then U=0;
label U= " Partnership, not married=1" ;
run;

/** Dummy for marriage**/
data analys(drop= i M_:);  set analys;
array q105[5] q1051-q1055;
array num_uni[5] num_uni1-num_uni5;
array M_[5] M_1-M_5;
do i=1 to 5;
            if num_uni[i] ne . & q105[i] ne . then M_[i]=1;
end;
m_s = sum(of M_[*]);
if m_s>0 then M=1;
if M=. then M=0;
label M= " Married=1" ;
run;


/*TVC  for marital status*/
data analys; set analys;
     if C=1               then marital=1;
else if D=1 & nbu=0       then marital=2;
else if V=1 & nbu=0       then marital=3;
else if U=1 & nbu=1       then marital=4;
else if M=1 & nbu=1       then marital=5;
else if U=1 & M=0 & nbu>1 then marital=6;
else if M=1 & nbu>1       then marital=7;
run;

proc formats;
value marital
 1='Alone, never in union'
 2='Alone, separated'
 3='Alone, widowed'
 4='Monogamy, informal union'
 5='Monogamy, married'
 6='Polygamy, only informal unions'
 7='Polygamy, at least one marriage';

 proc freq data=analys;
table marital;
format marital marital.;
run;


/** TVC transnationality of unions**/

/* uni_loc */
data analys(drop= i L_:); set analys;
array loc_conj[5] loc_conj1-loc_conj5;
array num_uni[5] num_uni1-num_uni5;
array L_[5] L_1-L_5;
do i=1 to 5;
     if loc_resp =  loc_conj[i] & num_uni[i] ne . then L_[i]=1;
else if loc_resp ne loc_conj[i] & num_uni[i] ne . then L_[i]=0;
end;
l_s = sum(of L_[*]);
if l_s=nbu & nbu>0 then uni_loc=1;
if l_s<nbu & nbu>0 then uni_loc=0;
run;


/******* example with E1 *********/

data E1(keep=ident year num_uni1 loc_resp loc_conj1); set analys;
if ident="E1";
if num_uni1 ne .;
run;

data E1; set E1;
uni=1;
if loc_resp=loc_conj1 then uni_loc=1;
                      else uni_loc=0;
run;

/** cuni **/
data E1; set E1;
by ident;
retain cuni;
if  first.ident then cuni=uni; else cuni=uni+cuni;
run;

/** cuni_loc **/
data E1; set E1;
by ident;
retain cuni_loc;
if  first.ident then cuni_loc=uni_loc; else cuni_loc=uni_loc+cuni_loc;
run;

data E1; set E1;
     if uni_loc=0 then trans1=1;
else if uni_loc=1 & cuni>cuni_loc then trans1=2;
else if uni_loc=1 & cuni=cuni_loc then trans1=3;
run;
 
proc format;
value trans1E
1='Transnational'
2='Reunified'
3='Always unified';


/****** With all unions ******/
/* uni_loc */
data analys (drop= i L_:); set analys;
array loc_conj[5] loc_conj1-loc_conj5;
array num_uni[5] num_uni1-num_uni5;
array L_[5] L_1-L_5;
do i=1 to 5;
     if loc_resp =  loc_conj[i] & num_uni[i] ne . then L_[i]=1;
else if loc_resp ne loc_conj[i] & num_uni[i] ne . then L_[i]=0;
end;
l_s = sum(of L_[*]);
if l_s=nbu & nbu>0 then uni_loc=1;
if l_s<nbu & nbu>0 then uni_loc=0;
run;


/* suni_id */
data analys (drop=x1 x2 x3 x4 x5) ; set analys;
x1=put(num_uni1, $1.);
x2=put(num_uni2, $1.);
x3=put(num_uni3, $1.);
x4=put(num_uni4, $1.);
x5=put(num_uni5, $1.);
id_uni= x1 || x2 ||x3 || x4 || x5;
run;

data analys; set analys;
suni_id= ident || id_uni;
run; 

/** cuni **/
data analys; set analys;
if nbu>0 then uni=1;
run;

proc sort data=analys; by suni_id;
run;

data analys; set analys;
by suni_id;
retain cuni;
if  first.suni_id & nbu>0 then cuni=uni; else cuni=uni+cuni;
run;

/* cuni_loc*/
data analys; set analys;
by suni_id;
retain cuni_loc;
if  first.suni_id then cuni_loc=uni_loc; else cuni_loc=uni_loc+cuni_loc;
run;

/* variable trans */

proc format;
  value transa 
   0= " No partner/spouse "
   1= " Transnational "
   2= " Reunified "
   3= " Always unified " ;
run;

data analys; set analys;
     if uni_loc=. then trans1=0;
else if uni_loc=0 then trans1=1;
else if uni_loc=1 & cuni>cuni_loc then trans1=2;
else if uni_loc=1 & cuni=cuni_loc then trans1=3;
format trans1 transa.;
run;
 

proc freq data=analys;
table trans1;
format trans1 trans.;
run;


/* variable trans2 */
proc format;
  value transb
   0= " Never in union "
   1= " Separated or widowed "
   2= " Transnational "
   3= " Reunified " 
   4= " Always unified " ;
run;

data analys; set analys;
     if trans1=0 & C=1        then trans2=0;
else if trans1=0 & (D=1 | V=1) then trans2=1; 
else if trans1=1              then trans2=2; 
else if trans1=2              then trans2=3;
else if trans1=3              then trans2=4;
format trans2 transb. ; 
run;

proc freq data=analys;
table trans2;
format trans2 transb.;
run;
